/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* --------------------------------------------------------------------------
 * Block Reading/writing (2925 only)
 * -------------------------------------------------------------------------- */


#ifndef __IOCOMMON_H
#define __IOCOMMON_H


#define MAX_BLOCK_LEN_2925  127

#ifdef __cplusplus
extern "C" {
#endif
  

b_errtype EXPORT BestBasicBlockWrite(
				     b_handletype handle,
				     b_int32      register_number,
				     b_int8ptr    bt_ptr,
				     b_int64      num_of_bytes
				     );


b_errtype EXPORT BestBasicBlockRead(
				    b_handletype  handle,
				    b_int32       register_number,
				    b_int8ptr     bt_ptr,
				    b_int32       num_of_bytes
				    );


b_errtype BestBasicCommand8Bit(
    b_handletype handle,
    b_int32 addr,       /* 8-bit address to be sent to Best */
    b_int8 cmd,         /* CMD_READ or CMD_WRITE */
    b_int8ptr  byteptr,   /* addr of data to be read/written */
    b_int8 regwidth,    /* using register width nn */
    b_int64 NumBytes);  /* length of data at byteptr */


/* BestBasicCommand

   The new 16-bit register file has a different philosophy of how the
   card is addressed. You should imagine onboard calls like a procedure
   that gets called through this interface.

   arguments:
   handle	- identifies port and hardware
   cmdcode	- 16-bit code identifying the called function
   inptr	- pointer to arguments for the call
   insize	- size of arguments
   outptr	- result of the called function
   outsize	- size of the result in bytes

   If a the in or out buffer is set to zero then the according size parameter
   is ignored and implicitly set to zero. In this case also outsize may be
   set to zero

   return values:
   B_E_OK
   B_E_FUNC	- the onboard function failed, useaccording CAPI calls to
   		  get detailed error message
*/

b_errtype EXPORT BestBasicCommand (b_handletype handle,
				   b_int16      cmdcode,
				   b_int8ptr    inptr,
				   b_int16      insize,
				   b_int8ptr    outptr,
				   b_int16     *outsize);


/* BestBasicCommandVariable

  This functions calls BestBasicCommand and handles buffers with variable
  length. A Transfer of this type MUST be defined in reg*.h as VARIABLE 
  or LENGTHNEGOTIABLE */
b_errtype EXPORT BestBasicCommandVariable (b_handletype handle,
				   b_int16   cmdcode,
				   b_int8ptr inptr,
				   b_int16   insize,
				   b_int8ptr outptr,
				   b_int16   *outsize);


/* --------------------------------------------------------------------------
 * Block Reading/writing (2926 only)
 * Note that a limited subset of b_resourcetype is valid for block I/O. 
 * -------------------------------------------------------------------------- */

b_errtype BestBasicBlockCommand(
    b_handletype handle,
    b_blockiorestype resource,	/* onboard resource to read/write */
    b_int32 offset,		/* starting offset in onboard memory */
    b_int32 num_bytes,		/* length of data at byteptr */
    b_int32 granularity,	/* acceptable data element width in bytes */
				/* Granularity = 1 means; don't care */
    int     write_cmd,		/* CMD_READ or CMD_WRITE */
    b_int8ptr  data		/* addr of caller's buffer to read/write */
    );


b_errtype BestWaitForClose (
  b_handletype handle,
  b_int32 timeout
  );


#ifdef __cplusplus
}
#endif


#endif





